/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.busmon.parser;

import com.quantumdata.busmon.parser.CECByte;
import com.quantumdata.busmon.parser.CECDataBlock;
import com.quantumdata.busmon.parser.DataBlock;
import com.quantumdata.busmon.parser.ErrorDataBlock;
import com.quantumdata.busmon.parser.FiveVoltSenseDataBlock;
import com.quantumdata.busmon.parser.HotplugDataBlock;
import com.quantumdata.busmon.parser.I2CDataBlock;
import com.quantumdata.busmon.parser.I2CMessageType;
import com.quantumdata.busmon.parser.I2CSignal;
import com.quantumdata.busmon.parser.ProgramDataBlock;
import com.quantumdata.busmon.parser.TypeConverter;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.BufferUnderflowException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Packet
implements Externalizable {
    private static final long serialVersionUID = 1L;
    protected int ordinal;
    protected int version;
    protected long dataBlockSize;
    protected DataBlock dataBlock;
    protected Integer[] packetData;
    public static final short SOURCE_EMPTY = 0;
    public static final short SOURCE_CEC = 1;
    public static final short SOURCE_I2C = 2;
    public static final short SOURCE_HOTPLUG = 3;
    public static final short SOURCE_ERROR = 4;
    public static final short SOURCE_5VOLTSENSE = 5;
    public static final short SOURCE_PROGRAM = 1000;
    public static final short SOURCE_UNKNOWN = -1;

    public Packet() {
        this.packetData = new Integer[0];
    }

    public Packet(Integer[] integerArray, int n) {
        this.parse(integerArray);
        this.ordinal = n;
    }

    public Packet(Vector<Integer> vector, int n) {
        Integer[] integerArray = new Integer[vector.size()];
        this.parse(vector.toArray(integerArray));
        this.ordinal = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.ordinal);
        int n = this.packetData.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeInt(this.packetData[i]);
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.clear();
        this.ordinal = objectInput.readInt();
        int n = objectInput.readInt();
        Integer[] integerArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            integerArray[i] = objectInput.readInt();
        }
        this.parse(integerArray);
    }

    public void clear() {
        this.dataBlockSize = 0L;
        this.dataBlock = null;
    }

    public void parse(Integer[] integerArray) {
        boolean bl = true;
        if (integerArray == null) {
            return;
        }
        if (integerArray.length == 0) {
            return;
        }
        this.packetData = (Integer[])integerArray.clone();
        try {
            int n = this.packetData[0];
            switch (n) {
                case 1: {
                    int n2 = TypeConverter.composeInt(this.packetData, 1);
                    this.dataBlockSize = TypeConverter.composeLong(this.packetData, 3);
                    switch (n2) {
                        case 1: {
                            this.dataBlock = new CECDataBlock(this.packetData);
                            break;
                        }
                        case 2: {
                            this.dataBlock = new I2CDataBlock(this.packetData);
                            break;
                        }
                        case 3: {
                            this.dataBlock = new HotplugDataBlock();
                            bl = ((HotplugDataBlock)this.dataBlock).parse(this.packetData);
                            break;
                        }
                        case 4: {
                            this.dataBlock = new ErrorDataBlock();
                            bl = ((ErrorDataBlock)this.dataBlock).parse(this.packetData);
                            break;
                        }
                        case 5: {
                            this.dataBlock = new FiveVoltSenseDataBlock(this.packetData);
                            break;
                        }
                        case 0: {
                            bl = false;
                            break;
                        }
                        case 1000: {
                            bl = false;
                            break;
                        }
                        default: {
                            bl = false;
                        }
                    }
                    if (!bl) {
                        this.dataBlock = null;
                    }
                    return;
                }
            }
            this.dataBlock = new ProgramDataBlock(1);
            bl = false;
            return;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            this.clear();
            return;
        }
    }

    public short getSource() {
        if (this.dataBlock == null) {
            return 0;
        }
        if (this.dataBlock instanceof ProgramDataBlock) {
            return 1000;
        }
        if (this.dataBlock instanceof CECDataBlock) {
            return 1;
        }
        if (this.dataBlock instanceof I2CDataBlock) {
            return 2;
        }
        if (this.dataBlock instanceof HotplugDataBlock) {
            return 3;
        }
        if (this.dataBlock instanceof ErrorDataBlock) {
            return 4;
        }
        if (this.dataBlock instanceof FiveVoltSenseDataBlock) {
            return 5;
        }
        return -1;
    }

    public long getDataBlockSize() {
        return this.dataBlockSize;
    }

    public boolean isError() {
        if (this.dataBlock == null) {
            return false;
        }
        if (this.dataBlock instanceof I2CDataBlock && ((I2CDataBlock)this.dataBlock).getMessage() == null && ((I2CDataBlock)this.dataBlock).getRawMessage() != null) {
            return true;
        }
        return this.dataBlock.isError();
    }

    public boolean isEDID() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock instanceof I2CDataBlock && ((I2CDataBlock)this.dataBlock).getMessageType() == I2CMessageType.EDID;
    }

    public boolean isDDCCI() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock instanceof I2CDataBlock && ((I2CDataBlock)this.dataBlock).getMessageType() == I2CMessageType.DDCCI;
    }

    public boolean isHDCP() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock instanceof I2CDataBlock && ((I2CDataBlock)this.dataBlock).getMessageType() == I2CMessageType.HDCP;
    }

    public boolean isCEC() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock instanceof CECDataBlock;
    }

    public boolean isI2C() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock instanceof I2CDataBlock;
    }

    public boolean isEvent() {
        if (this.dataBlock == null) {
            return false;
        }
        return this.dataBlock instanceof ProgramDataBlock || this.dataBlock instanceof HotplugDataBlock || this.dataBlock instanceof FiveVoltSenseDataBlock;
    }

    public boolean isOther() {
        return !this.isDDCCI() && !this.isHDCP() && !this.isEDID() && !this.isCEC() && !this.isEvent();
    }

    public int getSpeed() {
        if (this.dataBlock == null) {
            return 0;
        }
        if (this.dataBlock instanceof I2CDataBlock) {
            return ((I2CDataBlock)this.dataBlock).getPeriod();
        }
        return 0;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    public long getTimestamp() {
        if (this.dataBlock == null) {
            return 0L;
        }
        if (this.dataBlock instanceof CECDataBlock) {
            return ((CECDataBlock)this.dataBlock).getTimestamp();
        }
        if (this.dataBlock instanceof I2CDataBlock) {
            return ((I2CDataBlock)this.dataBlock).getTimestamp();
        }
        if (this.dataBlock instanceof HotplugDataBlock) {
            return ((HotplugDataBlock)this.dataBlock).getTimestamp();
        }
        if (this.dataBlock instanceof FiveVoltSenseDataBlock) {
            return ((FiveVoltSenseDataBlock)this.dataBlock).getTimestamp();
        }
        return 0L;
    }

    public String getDirection() {
        if (this.dataBlock == null) {
            return "";
        }
        if (this.dataBlock instanceof I2CDataBlock && ((I2CDataBlock)this.dataBlock).message != null) {
            return ((I2CDataBlock)this.dataBlock).message.getDirection();
        }
        if (this.dataBlock instanceof CECDataBlock && ((CECDataBlock)this.dataBlock).message != null) {
            return ((CECDataBlock)this.dataBlock).message.getDirection();
        }
        return "";
    }

    public String getDescription() {
        if (this.dataBlock != null) {
            return this.dataBlock.getType();
        }
        return "Empty Packet";
    }

    public String getDetails() {
        if (this.dataBlock != null) {
            return this.dataBlock.getSummary();
        }
        return "Empty Packet";
    }

    public String getExtendedDetails() {
        if (this.dataBlock != null) {
            return this.dataBlock.getDetails();
        }
        return "Empty Packet";
    }

    public Integer[] getRawData() {
        return (Integer[])this.packetData.clone();
    }

    public DataBlock getDataBlock() {
        return this.dataBlock;
    }

    public String getRawString() {
        StringBuffer stringBuffer;
        block4: {
            block3: {
                if (this.dataBlock == null) {
                    return "";
                }
                stringBuffer = new StringBuffer();
                if (!(this.dataBlock instanceof I2CDataBlock)) break block3;
                Vector<I2CSignal> vector = ((I2CDataBlock)this.dataBlock).getRawMessage();
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append(String.format("%c", Character.valueOf((char)vector.get(i).getData())));
                }
                break block4;
            }
            if (!(this.dataBlock instanceof CECDataBlock)) break block4;
            Vector<CECByte> vector = ((CECDataBlock)this.dataBlock).getRawMessage();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(String.format("%02X", vector.get(i).getData()));
            }
        }
        return stringBuffer.toString();
    }

    public String getHexString() {
        StringBuffer stringBuffer;
        block4: {
            block3: {
                if (this.dataBlock == null) {
                    return "";
                }
                stringBuffer = new StringBuffer();
                if (!(this.dataBlock instanceof I2CDataBlock)) break block3;
                Vector<I2CSignal> vector = ((I2CDataBlock)this.dataBlock).getRawMessage();
                for (int i = 0; i < vector.size(); ++i) {
                    stringBuffer.append(String.format("%02X", vector.get(i).getData()));
                }
                break block4;
            }
            if (!(this.dataBlock instanceof CECDataBlock)) break block4;
            Vector<CECByte> vector = ((CECDataBlock)this.dataBlock).getRawMessage();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(String.format("%02X", vector.get(i).getData()));
            }
        }
        return stringBuffer.toString();
    }

    public String getHex() {
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        StringBuffer stringBuffer3 = new StringBuffer();
        if (this.packetData == null || this.packetData.length == 0) {
            return "No binary data for this packet type.";
        }
        if (this.dataBlock instanceof I2CDataBlock) {
            int n;
            Vector<I2CSignal> vector = ((I2CDataBlock)this.dataBlock).getRawMessage();
            if (vector == null) {
                return "No data.";
            }
            if (vector.size() == 0) {
                return "No data.";
            }
            stringBuffer.append(String.format("Data Size: %d packets\n", vector.size()));
            boolean bl = false;
            int n2 = 0;
            for (int i = 0; i < vector.size(); ++i) {
                I2CSignal i2CSignal = vector.get(i);
                if (bl) {
                    for (n = 0; n < 7 - (n2 - 1) % 8; ++n) {
                        stringBuffer2.append("   ");
                        stringBuffer3.append("  ");
                    }
                    if (stringBuffer2 != null) {
                        stringBuffer.append(stringBuffer2);
                    }
                    if (stringBuffer2 != null && stringBuffer3 != null) {
                        stringBuffer.append(" | ");
                    }
                    if (stringBuffer3 != null) {
                        stringBuffer.append(stringBuffer3);
                    }
                    stringBuffer.append('\n');
                    stringBuffer2 = new StringBuffer();
                    stringBuffer3 = new StringBuffer();
                }
                switch (i2CSignal.getType()) {
                    case 1: {
                        stringBuffer3.append("\n* START *");
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (bl) {
                            stringBuffer.append(String.format("%04X  ", n2));
                            for (n = 0; n < n2 % 8; ++n) {
                                stringBuffer2.append("   ");
                                stringBuffer3.append("  ");
                            }
                            bl = false;
                        }
                        stringBuffer2.append(String.format("%02X", i2CSignal.getData()));
                        if (i2CSignal.getData() > 32 && i2CSignal.getData() < 127) {
                            stringBuffer3.append(String.format("%c ", i2CSignal.getData()));
                        } else {
                            stringBuffer3.append(". ");
                        }
                        stringBuffer2.append(i2CSignal.getAck() ? " " : "-");
                        ++n2;
                        break;
                    }
                    case 3: {
                        stringBuffer3.append("\n* STOP *");
                        bl = true;
                        break;
                    }
                }
                if (n2 % 8 != 0) continue;
                bl = true;
            }
            for (n = 0; n < 7 - (n2 - 1) % 8; ++n) {
                stringBuffer2.append("   ");
                stringBuffer3.append("  ");
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer2 != null && stringBuffer3 != null) {
                stringBuffer.append(" | ");
            }
            if (stringBuffer3 != null) {
                stringBuffer.append(stringBuffer3);
            }
            return stringBuffer.toString();
        }
        if (this.dataBlock instanceof CECDataBlock) {
            int n;
            int n3;
            Vector<CECByte> vector = ((CECDataBlock)this.dataBlock).getRawMessage();
            if (vector == null) {
                return "No data.";
            }
            if (vector.size() == 0) {
                return "No data.";
            }
            stringBuffer.append(String.format("Data Size: %d bytes\n", vector.size()));
            boolean bl = false;
            for (n3 = 0; n3 < vector.size(); ++n3) {
                if (n3 % 4 == 0) {
                    bl = true;
                }
                CECByte cECByte = vector.get(n3);
                if (bl) {
                    if (stringBuffer2 != null) {
                        stringBuffer.append(stringBuffer2);
                    }
                    if (stringBuffer2 != null && stringBuffer3 != null) {
                        stringBuffer.append(" | ");
                    }
                    if (stringBuffer3 != null) {
                        stringBuffer.append(stringBuffer3);
                    }
                    stringBuffer.append('\n');
                    stringBuffer2 = new StringBuffer();
                    stringBuffer3 = new StringBuffer();
                    stringBuffer.append(String.format("%04X  ", n3));
                    for (n = 0; n < n3 % 4; ++n) {
                        stringBuffer2.append("    ");
                        stringBuffer3.append("  ");
                    }
                    bl = false;
                }
                stringBuffer2.append(cECByte.toString());
                if (cECByte.getData() > 32 && cECByte.getData() < 127) {
                    stringBuffer3.append(String.format("%c ", cECByte.getData()));
                } else {
                    stringBuffer3.append(". ");
                }
                stringBuffer2.append(cECByte.getACK() ? "+" : "-");
                stringBuffer2.append(cECByte.getEOM() ? "." : " ");
            }
            for (n = 0; n < 3 - (n3 - 1) % 4; ++n) {
                stringBuffer2.append("    ");
                stringBuffer3.append("  ");
            }
            if (stringBuffer2 != null) {
                stringBuffer.append(stringBuffer2);
            }
            if (stringBuffer3 != null) {
                stringBuffer.append(" | ");
                stringBuffer.append(stringBuffer3);
            }
            return stringBuffer.toString();
        }
        return "Hex data does not exist for this packet type.\n";
    }

    public static String getSourceName(short s) {
        switch (s) {
            case 0: {
                return "Empty";
            }
            case 1: {
                return "CEC";
            }
            case 2: {
                return "I2C";
            }
            case 3: {
                return "Hotplug";
            }
            case 4: {
                return "Error";
            }
            case 1000: {
                return "Program";
            }
            case 5: {
                return "5-Volt Sense";
            }
        }
        return "Unknown";
    }
}

